%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function sys_state = Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,L)
global tmp count ts ex1 ex2 ex3 ex4 ex5 ef ff

[n,m] = size(B);
[~,q] = size(F);
[p,~] = size(C);

X = xx(1:n);
hat_X_bar = xx(n+1:end);

% augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d1 = 0.05*(-1+2*rand(1,1)); %random value within [-0.05, 0.05]
% d1 = 0.01*sin(t);
d2 = 0.01 * cos(0.5*t);
d = [d1;d2];
f = piecewise_fa(t); 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y = C*X;
hat_y = C_bar*hat_X_bar;

% controller
Kf = -pinv(B)*F;
hat_X = hat_X_bar(1:n);
hat_f = hat_X_bar(n+1);

u = K*hat_X + Kf*hat_f;%FTC
% u = K*X; %baseline

%observer
dot_hat_X_bar = A_bar*hat_X_bar + B_bar*u + L*(y-hat_y);

% sys dynamic
Delta_At = Delta_A*sin(pi/10*t);
dot_X = (A + Delta_At)*X + B*u + F*f + D*d;

% data saving 
if mod(tmp,20)==0
    count = count + 1;
ts(count) = t;
ex1(count) = abs(X(1) - hat_X(1));
ex2(count) = abs(X(2) - hat_X(2));
ex3(count) = abs(X(3) - hat_X(3));
ex4(count) = abs(X(4) - hat_X(4));
ex5(count) = abs(X(5) - hat_X(5));
ef(count) = abs(f - hat_f);
ff(count) = f;
end
tmp = tmp + 1;

sys_state = [dot_X;dot_hat_X_bar];